MODULE interfaces
CONTAINS
   SUBROUTINE get_arguments( num_args, string, num_string, error )
 
   !  Purpose:
   !    To return the command line arguments supplied when a 
   !    program was started.  This version is designed for use
   !    with the Digital Visual Fortran system libraries.  
   !
   !  Record of revisions:
   !      Date       Programmer          Description of change
   !      ====       ==========          =====================
   !    03/02/96    S. J. Chapman        Original code
   !
   USE dflib          ! Use the Digital Visual Fortran system lib
   IMPLICIT NONE

   ! List of calling arguments:
   INTEGER,INTENT(OUT) :: num_args    ! No of arguments returned
   INTEGER,INTENT(IN) :: num_string   ! No of strings to hold args
   CHARACTER(len=*),DIMENSION(num_string),INTENT(OUT) :: string
                                      ! Array to hold arguments
   INTEGER,INTENT(OUT) :: error       ! Error flag: 0=no error
                                      !   -1=sys library error
                                      !   +num=too many arguments

   ! Define local variables
   INTEGER(KIND=2) :: i               ! Index variable
   INTEGER(KIND=2) :: status          ! Subroutine status

   ! Get number of arguments
   num_args = nargs()

   ! Check for too many arguments.
   IF ( num_args > num_string ) THEN ! too many
      error = num_args
      num_args = num_string
   ELSE
      error = 0
   END IF

   ! Get arguments. 
   DO i = 0, num_args-1
      CALL getarg (i, string(i+1), status )
      IF ( status < 0 ) then
         error = status
         EXIT
      END IF
   END DO

   END SUBROUTINE get_arguments

END MODULE interfaces
